/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.property.PropertySupport;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import java.util.Map;
import javax.annotation.Nonnull;

public class Material
implements Propertized {
    private final String name;
    private final String description;
    private final long materialHorizon;
    private final boolean isConsumed;
    private final boolean isConstant;
    private final double minBatch;
    private final double maxBatch;
    private final double batchStep;
    private final double safetyStock;
    private final long aggregationHorizon;
    private final PropertySupport propertySupport;
    public static final String DEFAULT_DESCRIPTION = "";
    public static final boolean DEFAULT_IS_CONSTANT = false;
    public static final boolean DEFAULT_IS_CONSUMED = true;
    public static final long DEFAULT_MATERIAL_HORIZON = -9223372036854775708L;
    public static final double DEFAULT_MIN_BATCH = 0.0;
    public static final double DEFAULT_MAX_BATCH = -1.0;
    public static final double DEFAULT_BATCH_STEP = 1.0;
    public static final double DEFAULT_SAFETY_STOCK = 0.0;
    public static final long DEFAULT_AGGREGATION_HORIZON = 0L;

    public Material(String name) {
        this(name, null, -9223372036854775708L);
    }

    public Material(String name, String description) {
        this(name, description, -9223372036854775708L);
    }

    public Material(String name, String description, boolean isConsumed, boolean isConstant) {
        this(name, description, -9223372036854775708L, isConsumed, isConstant);
    }

    public Material(String name, long materialHorizon) {
        this(name, null, materialHorizon);
    }

    public Material(String name, String description, long materialHorizon) {
        this(name, description, materialHorizon, true, false);
    }

    public Material(String name, String description, long materialHorizon, boolean isConsumed, boolean isConstant) {
        Preconditions.checkArgument(!GeneralizedRequest.isDateValid(materialHorizon) || materialHorizon >= 0L, "Material horizon must be nonnegative");
        this.name = name;
        this.description = description != null ? description : DEFAULT_DESCRIPTION;
        this.materialHorizon = materialHorizon;
        this.isConsumed = isConsumed;
        this.isConstant = isConstant;
        this.propertySupport = new PropertySupport();
        this.minBatch = 0.0;
        this.maxBatch = -1.0;
        this.batchStep = 1.0;
        this.safetyStock = 0.0;
        this.aggregationHorizon = 0L;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getMaterialHorizon() {
        return this.materialHorizon;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public boolean isConsumed() {
        return this.isConsumed;
    }

    public double getMinBatch() {
        return this.minBatch;
    }

    public double getMaxBatch() {
        return this.maxBatch;
    }

    public double getBatchStep() {
        return this.batchStep;
    }

    public double getSafetyStock() {
        return this.safetyStock;
    }

    public long getAggregationHorizon() {
        return this.aggregationHorizon;
    }

    protected String formatHorizon() {
        return this.getMaterialHorizon() == -9223372036854775708L ? "inf" : DEFAULT_DESCRIPTION + this.getMaterialHorizon();
    }

    public String toString() {
        return "<Material:" + this.getName() + ", horizon=" + this.formatHorizon() + (this.isConstant ? ", ct" : DEFAULT_DESCRIPTION) + (this.isConsumed ? ", cu" : DEFAULT_DESCRIPTION) + ">";
    }

    @Override
    public void setProperties(Map<PropertyDefinition, String> properties, @Nonnull PropertyDefinitions definitions) {
        this.propertySupport.setProperties(this.getClass(), properties, definitions);
    }

    @Override
    public void resetProperties(@Nonnull Map<PropertyDefinition, Object> properties) {
        this.propertySupport.resetProperties(this.getClass(), properties);
    }

    @Override
    public void setProperty(@Nonnull PropertyDefinition pd, Object value) {
        this.propertySupport.setProperty(this.getClass(), pd, value);
    }

    @Override
    public Object getProperty(@Nonnull String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public Object getProperty(@Nonnull PropertyDefinition def) {
        return this.propertySupport.getProperty(this.getClass(), def);
    }

    @Override
    @Nonnull
    public Map<PropertyDefinition, Object> getProperties() {
        return this.propertySupport.getProperties();
    }

    protected Material(Builder bob) {
        this.name = bob.name;
        this.description = bob.description;
        this.isConstant = bob.isConstant;
        this.isConsumed = bob.isConsumed;
        this.materialHorizon = bob.materialHorizon;
        this.minBatch = bob.minBatch;
        this.maxBatch = bob.maxBatch;
        this.batchStep = bob.batchStep;
        this.safetyStock = bob.safetyStock;
        this.aggregationHorizon = bob.aggregationHorizon;
        this.propertySupport = new PropertySupport();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private boolean isConstant;
        private boolean isConsumed;
        private long materialHorizon;
        private double minBatch;
        private double maxBatch;
        private double batchStep;
        private double safetyStock;
        private long aggregationHorizon;

        protected Builder() {
            this.reset();
        }

        public Material build() {
            Preconditions.checkState(this.isValid(), "Cannot create material " + this.name + " because it has invalid parameteres.");
            return new Material(this);
        }

        public boolean isValid() {
            return this.name != null && (this.materialHorizon >= 0L || this.materialHorizon == -9223372036854775708L) && this.minBatch >= 0.0 && this.maxBatch != 0.0 && this.batchStep > 0.0 && (this.aggregationHorizon >= 0L || this.aggregationHorizon == -9223372036854775708L);
        }

        public void reset() {
            this.name = null;
            this.description = Material.DEFAULT_DESCRIPTION;
            this.isConstant = false;
            this.isConsumed = true;
            this.materialHorizon = -9223372036854775708L;
            this.minBatch = 0.0;
            this.maxBatch = -1.0;
            this.batchStep = 1.0;
            this.safetyStock = 0.0;
            this.aggregationHorizon = 0L;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description == null ? Material.DEFAULT_DESCRIPTION : description;
        }

        public void setConstant(boolean isConstant) {
            this.isConstant = isConstant;
        }

        public void setConsumed(boolean isConsumed) {
            this.isConsumed = isConsumed;
        }

        public void setMaterialHorizon(long materialHorizon) {
            this.materialHorizon = materialHorizon < 0L ? -9223372036854775708L : materialHorizon;
        }

        public void setMinBatch(double minBatch) {
            this.minBatch = minBatch <= 0.0 ? 0.0 : minBatch;
        }

        public void setMaxBatch(double maxBatch) {
            this.maxBatch = maxBatch <= 0.0 ? -1.0 : maxBatch;
        }

        public void setBatchStep(double batchStep) {
            this.batchStep = batchStep;
        }

        public void setSafetyStock(double safetyStock) {
            this.safetyStock = safetyStock;
        }

        public void setAggregationHorizon(long aggregationHorizon) {
            this.aggregationHorizon = aggregationHorizon < 0L ? -9223372036854775708L : aggregationHorizon;
        }

        public void setAll(Material m3) {
            this.name = m3.name;
            this.description = m3.description;
            this.isConstant = m3.isConstant;
            this.isConsumed = m3.isConsumed;
            this.materialHorizon = m3.materialHorizon;
            this.minBatch = m3.minBatch;
            this.maxBatch = m3.maxBatch;
            this.batchStep = m3.batchStep;
            this.safetyStock = m3.safetyStock;
            this.aggregationHorizon = m3.aggregationHorizon;
        }
    }
}

